<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3><?php echo e($data['meeting']); ?></h3>

                    <p><?php echo e(__('Meetings')); ?></p>
                </div>
                <div class="icon">
                    <i class="ion ion-ios-videocam"></i>
                </div>
                <a href="<?php echo e(route('meetings')); ?>" class="small-box-footer"><?php echo e(__('More info')); ?> <i
                        class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3><?php echo e($data['user']); ?></h3>

                    <p><?php echo e(__('Users')); ?></p>
                </div>
                <div class="icon">
                    <i class="ion ion-person-stalker"></i>
                </div>
                <a href="<?php echo e(route('users')); ?>" class="small-box-footer"><?php echo e(__('More info')); ?> <i
                        class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3><?php echo e(getCurrencySymbol() . $data['income']); ?></h3>

                    <p><?php echo e(__('Income')); ?></p>
                </div>
                <div class="icon">
                    <i class="ion ion-social-usd"></i>
                </div>
                <a href="<?php echo e(route('income')); ?>" class="small-box-footer"><?php echo e(__('More info')); ?> <i
                        class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3><?php echo e(ucfirst(getSetting('AUTH_MODE'))); ?></h3>

                    <p><?php echo e(__('Auth Mode')); ?></p>
                </div>
                <div class="icon">
                    <i class="ion ion-locked"></i>
                </div>
                <a href="<?php echo e(route('global-config')); ?>" class="small-box-footer"><?php echo e(__('More info')); ?> <i
                        class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6">
            <div class="card card-danger">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Users')); ?></h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="usersChart"
                        style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card card-danger">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Income')); ?> (<?php echo e(getCurrencySymbol()); ?>)</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart">
                        <canvas id="incomeChart"
                            style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6">
            <div class="card card-danger">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('User Registration')); ?></h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart">
                        <canvas id="userGraph"
                            style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card card-danger">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Meetings')); ?></h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart">
                        <canvas id="meetingGraph"
                            style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        let freeUsers = "<?php echo e($data['freeUsers']); ?>";
        let paidUsers = "<?php echo e($data['paidUsers']); ?>";
        let montlyIncome = JSON.parse("<?php echo e($data['montlyIncome']); ?>".replace(/&quot;/g, '"'));
        let userGraph = JSON.parse("<?php echo e($data['userGraph']); ?>".replace(/&quot;/g, '"'));
        let meetingGraph = JSON.parse("<?php echo e($data['meetingGraph']); ?>".replace(/&quot;/g, '"'));
        let currentYear = "<?php echo e(date('Y')); ?>";
    </script>

    <script src="<?php echo e(asset('js/chart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/chartjs-plugin-labels.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/admin.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.1.0\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>