<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="">
                <label><?php echo e($model->name . ' (' . $model->code . ')'); ?></label>
                <a href="<?php echo e('/languages/download-file/' . $model->code); ?>" class="float-right"><button
                        class="btn btn-warning btn-sm ml-1"
                        title="<?php echo e(__('Download File')); ?>"><?php echo e(__('Download File')); ?></button></a>
            </div>
            <hr>

            <form id="languagesEdit">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label><?php echo e(__('Direction')); ?></label>
                            <select id="direction" class="form-control">
                                <option value="ltr" <?php if($model->direction == 'ltr'): ?> selected <?php endif; ?>><?php echo e(__('LTR')); ?></option>
                                <option value="rtl" <?php if($model->direction == 'rtl'): ?> selected <?php endif; ?>><?php echo e(__('RTL')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label><?php echo e(__('Default')); ?></label>
                            <select id="default" class="form-control">
                                <option value="no" <?php if($model->default == 'no'): ?> selected <?php endif; ?>><?php echo e(__('No')); ?></option>
                                <option value="yes" <?php if($model->default == 'yes'): ?> selected <?php endif; ?>><?php echo e(__('Yes')); ?></option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label><?php echo e(__('Status')); ?></label>
                            <select id="status" class="form-control">
                                <option value="active" <?php if($model->status == 'active'): ?> selected <?php endif; ?>><?php echo e(__('Active')); ?></option>
                                <option value="inactive" <?php if($model->status == 'inactive'): ?> selected <?php endif; ?>><?php echo e(__('Inactive')); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label><?php echo e(__('File')); ?></label>
                            <input type="file" id="file" class="form-control" accept=".json">
                        </div>
                    </div>
                </div>

                <button type="submit" id="save" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                <a href="<?php echo e(route('languages')); ?>"><button type="button"
                        class="btn btn-default"><?php echo e(__('Back')); ?></button></a>
                <input type="hidden" id="id" value="<?php echo e($model->id); ?>">
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.1.0\resources\views/admin/language/edit.blade.php ENDPATH**/ ?>