<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    Payment Details
                    <img src="<?php echo e(asset('images/stripe_logo.png')); ?>" width="50px" style="float: right;">
                </div>
                <div class="card-body">
                    <?php if(Session::has('error')): ?>
                    <div class="alert alert-danger text-center">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
                        <p><?php echo e(Session::get('error')); ?></p>
                    </div>
                    <?php endif; ?>

                    <form role="form" action="<?php echo e(route('handlePayment')); ?>" method="post" class="validation" data-cc-on-file="false" data-stripe-publishable-key="<?php echo e(getSetting('STRIPE_KEY')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="form-group row">
                            <label class="col-md-4 col-form-label">Name on Card</label>

                            <div class="col-md-12">
                                <input type="text" class="form-control" required autofocus>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-md-4 col-form-label">Card Number</label>

                            <div class="col-md-12">
                                <input type="number" class="form-control card-number" size="20" autocomplete="off" required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-xs-12 col-md-4 form-group cvc required">
                                <label class="col-form-label">CVC</label>
                                <input autocomplete="off" class="form-control card-cvc" placeholder="e.g 415" size="4" type="number" />
                            </div>
                            <div class="col-xs-12 col-md-4 form-group expiration required">
                                <label class="col-form-label">Expiration Month</label>
                                <input class="form-control card-expiry-month" placeholder="MM" min="1" max="12" size="2" type="number" />
                            </div>
                            <div class="col-xs-12 col-md-4 form-group expiration required">
                                <label class="col-form-label">Expiration Year</label>
                                <input class="form-control card-expiry-year" placeholder="YYYY" size="4" type="number" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 hide error form-group">
                                <div class="alert-danger alert">Fix the errors before you begin.</div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-5 col-md-5 col-lg-3">
                                <button id="payNow" class="btn btn-danger btn-lg btn-block" type="submit">Pay Now: <?php echo e(getCurrencySymbol() . $price); ?></button>
                            </div>
                        </div>
                        <input type="hidden" name="type" value="<?php echo e($type); ?>">
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://js.stripe.com/v2/"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\resources\views/payment/pay.blade.php ENDPATH**/ ?>