<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <a href="<?php echo e(route('createUser')); ?>"><button class="btn btn-primary btn-sm" id="createUser"
                        title="<?php echo e(__('Create User')); ?>"><?php echo e(__('Create')); ?></button></a>
            </div>
            <br>
            <table class="table table-bordered table-striped table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Username')); ?></th>
                        <th><?php echo e(__('Email')); ?></th>
                        <th><?php echo e(__('Plan Type')); ?></th>
                        <th><?php echo e(__('Plan Status')); ?></th>
                        <th><?php echo e(__('Created Date')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($value->id); ?></td>
                            <td><?php echo e($value->username); ?></td>
                            <td><?php echo e($value->email); ?></td>
                            <td>
                                <?php if($value->plan_type == 'free'): ?>
                                    <span class="badge badge-info"><?php echo e(__('Free')); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-success"><?php echo e(__('Paid')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($value->plan_status == 'active'): ?>
                                    <span class="badge badge-success"><?php echo e(__('Active')); ?></span>
                                <?php elseif($value->plan_status == 'inactive'): ?>
                                    <span class="badge badge-info"><?php echo e(__('Inactive')); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-danger"><?php echo e(__('Expired')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($value->created_at); ?></td>
                            <td>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input user-status"
                                        data-id="<?php echo e($value->id); ?>" id="customSwitch<?php echo e($value->id); ?>"
                                        <?php echo e($value->status == 'active' ? 'checked' : ''); ?>>
                                    <label class="custom-control-label" for="customSwitch<?php echo e($value->id); ?>"></label>
                                </div>
                            </td>
                            <td>
                                <button class="btn btn-danger btn-sm delete-user" data-id="<?php echo e($value->id); ?>"
                                    title="<?php echo e(__('Delete')); ?>">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Username')); ?></th>
                        <th><?php echo e(__('Email')); ?></th>
                        <th><?php echo e(__('Plan Type')); ?></th>
                        <th><?php echo e(__('Plan Status')); ?></th>
                        <th><?php echo e(__('Created Date')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Action')); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.1.0\resources\views/admin/user/index.blade.php ENDPATH**/ ?>