<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('style'); ?>
<!-- <link href="<?php echo e(asset('css/home.css')); ?>" rel="stylesheet"> -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid text-center">
        <h1>Choose your plan</h1>
        <div class="container">
            <div>
                <input type="radio" name="period" value="monthly" checked>
                <label for="monthly">Monthly</label>
                <input type="radio" name="period" value="yearly">
                <label for="yearly">Yearly</label>
            </div>
            <div class="card-deck mb-3 text-center">
                <div class="card col-lg-3">
                    <div class="card-header">
                        <?php echo e(getSetting('PRICING_PLAN_NAME_FREE')); ?>

                    </div>
                    <div class="card-body">
                        <h3>Free</h3>
                        <ul class="list-unstyled mt-3 mb-4">
                            <li><?php echo e(getSetting('MEETING_LIMIT')); ?> Meetings</li>
                            <li>Limited Meeting Time</li>
                        </ul>
                        <a href="<?php echo e(route('register')); ?>">
                            <button type="button" class="btn btn-secondary">Join Now</button>
                        </a>
                    </div>
                </div>
            
                <div class="card col-lg-3">
                    <div class="card-header">
                        <?php echo e(getSetting('PRICING_PLAN_NAME_PAID')); ?>

                    </div>
                    <div class="card-body">
                        <h3 id="montlyPrice">$<?php echo e(getSetting('MONTHLY_PRICE')); ?> <small>/month</small></h3>
                        <h3 id="yearlyPrice" hidden>$<?php echo e(getSetting('YEARLY_PRICE')); ?> <small>/year</small></h3>
                        <ul class="list-unstyled mt-3 mb-4">
                            <li>Unlimited Meetings</li>
                            <li>Unlimited Meeting Time</li>
                        </ul>
                        <button type="button" class="btn btn-primary">Buy Now!</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script type="text/javascript">
    $('input[name=period]').change(function() {
        if (this.value == 'monthly') {
            $("#yearlyPrice").attr('hidden', 'true');
            $("#montlyPrice").removeAttr('hidden');
        } else {
            $("#montlyPrice").attr('hidden', 'true');
            $("#yearlyPrice").removeAttr('hidden');
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\resources\views/pricing.blade.php ENDPATH**/ ?>