

<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <?php if(getSetting('PAYMENT_MODE') == 'disabled'): ?>
                <span
                    class="badge badge-warning p-2 mb-3"><?php echo e(__('The payment mode is disabled, enable now to make the features paid')); ?></span>
            <?php endif; ?>
            <table class="table table-bordered table-striped table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Username')); ?></th>
                        <th><?php echo e(__('Plan')); ?></th>
                        <th><?php echo e(__('Coupon')); ?></th>
                        <th><?php echo e(__('Amount')); ?></th>
                        <th><?php echo e(__('Currency')); ?></th>
                        <th><?php echo e(__('Type')); ?></th>
                        <th><?php echo e(__('Gateway')); ?></th>
                        <th><?php echo e(__('Transaction ID')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Transaction Date')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($value->id); ?></td>
                            <td><?php echo e($value->user->username); ?></td>
                            <td><?php echo e($value->plan->name); ?></td>
                            <td><?php echo e($value->coupon ? $value->coupon->name : '-'); ?></td>
                            <td><?php echo e($value->amount); ?></td>
                            <td><?php echo e($value->currency); ?></td>
                            <td><?php echo e($value->interval); ?></td>
                            <td><?php echo e($value->gateway); ?></td>
                            <td><?php echo e($value->payment_id); ?></td>
                            <td><?php echo e($value->status); ?></td>
                            <td><?php echo e($value->created_at); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Username')); ?></th>
                        <th><?php echo e(__('Plan')); ?></th>
                        <th><?php echo e(__('Coupon')); ?></th>
                        <th><?php echo e(__('Amount')); ?></th>
                        <th><?php echo e(__('Currency')); ?></th>
                        <th><?php echo e(__('Type')); ?></th>
                        <th><?php echo e(__('Gateway')); ?></th>
                        <th><?php echo e(__('Transaction ID')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Transaction Date')); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\jupitermeet_cc\JupiterMeet_2.5.0\jupitermeet\resources\views/admin/transaction.blade.php ENDPATH**/ ?>