<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid text-center">
        <h1 class="mb-3">Choose your plan</h1>
        <div class="container plan-selection mb-5 mb-md-0">
            <div class="mb-3 ">
                <input type="radio" name="period" value="monthly" id="monthly" checked>
                <label for="monthly" class="btn">Monthly</label>
                <input type="radio" name="period" value="yearly" id="yearly">
                <label for="yearly" class="btn">Yearly</label>
            </div>
            <div class="card-deck mb-3 text-center">
                <div class="card">
                    <div class="card-header">
                        <?php echo e(getSetting('PRICING_PLAN_NAME_FREE')); ?>

                    </div>
                    <div class="card-body">
                        <?php if(auth::user() && auth::user()->plan_type == 'free'): ?>
                            <div class="ribbon-wrapper ribbon-lg">
                                <div class="ribbon bg-primary">
                                    Current
                                </div>
                            </div>
                        <?php endif; ?>
                        <h3>Free</h3>
                        <ul class="list-unstyled mt-3 mb-4">
                            <li><?php echo e(getSetting('MEETING_LIMIT')); ?> Meetings</li>
                            <li>Limited Meeting Time</li>
                        </ul>
                        <a href="<?php echo e(route('register')); ?>">
                            <button type="button" class="btn btn-secondary" <?php if(auth()->guard()->check()): ?> disabled <?php endif; ?>>Join Now</button>
                        </a>
                    </div>
                </div>
            
                <div class="card">
                    <div class="card-header">
                        <?php echo e(getSetting('PRICING_PLAN_NAME_PAID')); ?>

                    </div>
                    <div class="card-body">
                        <?php if(auth::user() && auth::user()->plan_type == 'paid'): ?>
                            <div class="ribbon-wrapper ribbon-lg">
                                <div class="ribbon bg-primary">
                                    Current
                                </div>
                            </div>
                        <?php endif; ?>
                        <h3 id="montlyPrice"><?php echo e(getCurrencySymbol() . getSetting('MONTHLY_PRICE')); ?> <small>/month</small></h3>
                        <h3 id="yearlyPrice" hidden><?php echo e(getCurrencySymbol() . getSetting('YEARLY_PRICE')); ?> <small>/year</small></h3>
                        <ul class="list-unstyled mt-3 mb-4">
                            <li>Unlimited Meetings</li>
                            <li>Unlimited Meeting Time</li>
                        </ul>
                        <form action="payment">
                            <input type="hidden" id="type" name="type" value="monthly">
                            <button type="submit" class="btn btn-primary" <?php if(auth::user() && auth::user()->plan_type == 'paid'): ?> disabled <?php endif; ?>>Buy Now</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\resources\views/payment/pricing.blade.php ENDPATH**/ ?>