<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <?php if(getSetting('PAYMENT_MODE') == 'disabled'): ?>
                <span
                    class="badge badge-warning p-2 mb-3"><?php echo e(__('The payment mode is disabled, enable now to make the features paid')); ?></span>
            <?php endif; ?>
            <table class="table table-bordered table-striped table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Username')); ?></th>
                        <th><?php echo e(__('Amount')); ?></th>
                        <th><?php echo e(__('Currency')); ?></th>
                        <th><?php echo e(__('Type')); ?></th>
                        <th><?php echo e(__('Gateway')); ?></th>
                        <th><?php echo e(__('Transaction ID')); ?></th>
                        <th><?php echo e(__('Plan Start Date')); ?></th>
                        <th><?php echo e(__('Plan End Date')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($value->id); ?></td>
                            <td><?php echo e($value->username); ?></td>
                            <td><?php echo e($value->amount); ?></td>
                            <td><?php echo e($value->currency); ?></td>
                            <td>
                                <?php if($value->type == 'monthly'): ?>
                                    <span class="badge badge-info"><?php echo e(__('Monthly')); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-success"><?php echo e(__('Yearly')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(ucfirst($value->gateway)); ?></td>
                            <td><?php echo e($value->transaction_id); ?></td>
                            <td><?php echo e($value->plan_start_date); ?></td>
                            <td><?php echo e($value->plan_end_date); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Username')); ?></th>
                        <th><?php echo e(__('Amount')); ?></th>
                        <th><?php echo e(__('Currency')); ?></th>
                        <th><?php echo e(__('Type')); ?></th>
                        <th><?php echo e(__('Gateway')); ?></th>
                        <th><?php echo e(__('Transaction ID')); ?></th>
                        <th><?php echo e(__('Plan Start Date')); ?></th>
                        <th><?php echo e(__('Plan End Date')); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.1.0\resources\views/admin/income.blade.php ENDPATH**/ ?>