<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page . ' | ' . $meeting->title); ?>

<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('css/meeting.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container meeting-details">
        <div class="row justify-content-center">
            <div class="col-lg-5">
                <div class="card">
                    <div class="card-header">
                        <h5><?php echo e($meeting->title); ?></h5>
                    </div>
                    <div class="card-body pb-0">
                        <div class="ribbon-wrapper ribbon-lg ribbon-left">
                            <div class="ribbon bg-primary" title="<?php echo e(__('Time Limit')); ?>">
                                <?php echo e($meeting->limitedTimeMeeting ? getSetting('TIME_LIMIT') . __('Minutes') : __('Unlimited')); ?>

                            </div>
                        </div>
                        <form id="passwordCheck">
                            <div class="form-group">
                                <h5><i class="fa fa-id-badge mr-1"></i> <?php echo e($meeting->meeting_id); ?></h5>
                            </div>
                            <div class="form-group">
                                <p class="mb-1"><?php echo e($meeting->description ? $meeting->description : '-'); ?></p>
                            </div>

                            <div class="form-group row" <?php if(Auth::check()): ?> hidden <?php endif; ?>>
                                <label for="username" class="col-md-3"><?php echo e(__('Name')); ?></label>
                                <div class="col-md-9">
                                    <input type="text" id="username" class="form-control"
                                        value="<?php echo e($meeting->username); ?>" placeholder="<?php echo e(__('Enter your name')); ?>"
                                        maxlength="8" />
                                </div>
                            </div>

                            <?php if($meeting->password): ?>
                                <div class="form-group row">
                                    <label for="password" class="col-md-3"><?php echo e(__('Password')); ?></label>
                                    <div class="col-md-9">
                                        <input id="password" type="text" class="form-control" name="password"
                                            placeholder="<?php echo e(__('Enter meeting password')); ?>" maxlength="8" required />
                                        <input type="hidden" name="id" value="<?php echo e($meeting->id); ?>" />
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="form-group row">
                                <div class="col-md-9 offset-md-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="muteCamera" />
                                        <label class="form-check-label" for="muteCamera"><?php echo e(__('Camera Off')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="col-md-9 offset-md-3">
                                    <button class="btn btn-primary" id="joinMeeting" data-toggle="tooltip"
                                        data-placement="top" title="<?php echo e(__('Join Meeting')); ?>" type="submit"
                                        disabled><?php echo e(__('Join')); ?></button>
                                    <button class="btn btn-secondary updateDevices" type="button" data-toggle="tooltip"
                                        data-placement="top" title="<?php echo e(__('Settings')); ?>"><i
                                            class="fa fa-cog"></i></button>
                                    <button class="btn btn-info" type="button" data-toggle="modal"
                                        data-target="#shortcutInfo" data-toggle="tooltip" data-placement="top"
                                        title="<?php echo e(__('Shortcut Keys information')); ?>"><i
                                            class="fa fa-info"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid meeting-section">
        <div class="row">
            <div id="videos">
                <div class="videoContainer">
                    <img src="<?php echo e(asset('storage/images/SECONDARY_LOGO.png')); ?>" class="meeting-logo"
                        alt="<?php echo e(getSetting('APPLICATION_NAME')); ?>" />
                    <video id="localVideo" autoplay playsinline muted></video>
                    <span class="local-user-name"></span>
                </div>
            </div>
        </div>

        <div class="meeting-info text-center">
            <span id="meetingIdInfo" class="text-center"></span>
            <span id="timer" class="text-center"></span>
        </div>

        <div class="chat-panel">
            <div class="chat-box">
                <div class="chat-header">
                    <?php echo e(__('Chat')); ?>

                    <i class="fas fa-times close-panel"></i>
                </div>
                <div class="chat-body">
                    <div class="empty-chat-body">
                        <i class="fa fa-comments chat-icon"></i>
                    </div>
                </div>
                <div class="chat-footer">
                    <form id="chatForm">
                        <div class="input-group">
                            <input type="text" id="messageInput" class="form-control note-input"
                                placeholder="<?php echo e(__('Type a message')); ?>" autocomplete="off" maxlength="250" />
                            <div class="input-group-append">
                                <button id="sendMessage" class="btn btn-outline-secondary" type="submit"
                                    title="<?php echo e(__('Send')); ?>">
                                    <i class="far fa-paper-plane"></i>
                                </button>
                                <button id="selectFile" class="btn btn-outline-secondary" title="<?php echo e(__('Attach File')); ?>"
                                    type="button">
                                    <i class="fas fa-paperclip"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                    <input type="file" name="file" id="file" data-max="50" hidden />
                </div>
            </div>
        </div>

        <div class="meeting-options">
            <button class="btn meeting-option" title="<?php echo e(__('Chat')); ?>" id="openChat">
                <i class="far fa-comment-alt"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Invite')); ?>" id="add">
                <i class="fas fa-user-plus"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Mute/Unmute Mic')); ?>" id="toggleMic">
                <i class="fa fa-microphone"></i>
            </button>
            <button class="btn btn-danger" title="<?php echo e(__('Leave Meeting')); ?>" id="leave">
                <i class="fas fa-phone"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('On/Off Camera')); ?>" id="toggleVideo">
                <i class="fa fa-video"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Rotate Camera')); ?>" id="toggleCam">
                <i class="fas fa-camera"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Start/Stop ScreenShare')); ?>" id="screenShare">
                <i class="fa fa-desktop"></i>
            </button>
            <button class="btn meeting-option updateDevices" title="<?php echo e(__('Update Devices')); ?>">
                <i class="fa fa-cog"></i>
            </button>
        </div>
    </div>

    <div class="modal fade" id="previewModal" tabindex="-1" role="dialog" aria-labelledby="previewModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="previewModalLabel"><?php echo e(__('File Preview')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="previewImage" src="" />
                    <p id="previewFilename"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="button" id="sendFile" class="btn btn-primary"><?php echo e(__('Send')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="displayModal" tabindex="-1" role="dialog" aria-labelledby="displayModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="displayModalLabel"><?php echo e(__('File Display')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="displayImage" src="" />
                    <p id="displayFilename"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="button" id="downloadFile" class="btn btn-primary"><?php echo e(__('Download')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deviceSettings" tabindex="-1" role="dialog" aria-labelledby="deviceSettingsLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deviceSettingsLabel"><?php echo e(__('Device Settings')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="videoQualitySelect"><?php echo e(__('Video Quality')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="videoQualitySelect" class="form-control">
                                <option id="QVGA" data-width="320" data-height="240"><?php echo e(__('QVGA')); ?></option>
                                <option id="VGA" data-width="640" data-height="480"><?php echo e(__('VGA')); ?></option>
                                <option id="HD" data-width="1280" data-height="720"><?php echo e(__('HD')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="audioSource"><?php echo e(__('Audio input source')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="audioSource" class="form-control"></select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="videoSource"><?php echo e(__('Video source')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="videoSource" class="form-control"></select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="shortcutInfo" tabindex="-1" role="dialog" aria-labelledby="shortcutInfoLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="shortcutInfoLabel"><?php echo e(__('Settings')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Shortcut Key')); ?></th>
                                <th scope="col"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <th scope="row">C</th>
                                <td><?php echo e(__('Chat')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">F</th>
                                <td><?php echo e(__('Attach File')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">A</th>
                                <td><?php echo e(__('Mute/Unmute Audio')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">L</th>
                                <td><?php echo e(__('Leave Meeting')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">V</th>
                                <td><?php echo e(__('On/Off Video')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">S</th>
                                <td><?php echo e(__('Screen Share')); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        const userInfo = {
            username: username.value,
            meetingId: "<?php echo e($meeting->meeting_id); ?>"
        };

        const passwordRequired = "<?php echo e($meeting->password); ?>";
        const isModerator = "<?php echo e($meeting->isModerator); ?>";
        const limitedTimeMeeting = "<?php echo e($meeting->limitedTimeMeeting); ?>";
    </script>
    <script src="<?php echo e(asset('js/socket.io.js')); ?>"></script>
    <script src="<?php echo e(asset('js/easytimer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/adapter.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/siofu.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/opentok-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/meeting.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.1.0\resources\views/meeting.blade.php ENDPATH**/ ?>