<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(getSelectedLanguage()->direction); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Styles -->
    <style type="text/css">
        :root {
            --secondary-color: #536d79;
            --primary-color: <?php echo e(getSetting('PRIMARY_COLOR')); ?>;
        }

    </style>
    <link href="<?php echo e(asset('css/app.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/fa.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/toastr.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/images/FAVICON.png')); ?>">
    <?php echo $__env->yieldContent('style'); ?>
</head>

<body>
    <div id="app">
        <nav class="navbar navbar-expand-md shadow-sm">
            <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                <img src="<?php echo e(asset('storage/images/PRIMARY_LOGO.png')); ?>"
                    alt="<?php echo e(getSetting('APPLICATION_NAME')); ?>" width="160px">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="<?php echo e(__('Toggle navigation')); ?>">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <!-- Left Side Of Navbar -->
                <ul class="navbar-nav mr-auto">

                </ul>

                <!-- Right Side Of Navbar -->
                <ul class="navbar-nav ml-auto">
                    <?php if(getLanguages()->count() > 1): ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa fa-globe"></i> <?php echo e(getSelectedLanguage()->name); ?>

                            </a>
                            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <?php $__currentLoopData = getLanguages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="dropdown-item <?php if(getSelectedLanguage()->name == $language->name): ?> active <?php endif; ?>"
                                        href="<?php echo e(route('language', ['locale' => $language->code])); ?>"><?php echo e($language->name); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </li>
                    <?php endif; ?>

                    <!-- Authentication Links -->
                    <?php if(auth()->guard()->guest()): ?>
                        <?php if(getSetting('AUTH_MODE') == 'enabled' && getSetting('PAYMENT_MODE') == 'enabled'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('pricing')); ?>"><?php echo e(__('Pricing')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if(Route::has('login') && getSetting('AUTH_MODE') == 'enabled'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if(Route::has('register') && getSetting('AUTH_MODE') == 'enabled'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if(Auth::user()->role == 'admin'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('admin')); ?>"><?php echo e(__('Admin')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if(Auth::user()->plan_type == 'free' && getSetting('AUTH_MODE') == 'enabled' && getSetting('PAYMENT_MODE') == 'enabled'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('pricing')); ?>">
                                    <span class="badge badge-warning p-1"><?php echo e(__('Upgrade')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(getSetting('AUTH_MODE') == 'enabled'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                            </li>
                        <?php endif; ?>

                        <li class="nav-item dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                <?php echo e(Auth::user()->username); ?>

                            </a>

                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                <?php if(getSetting('PAYMENT_MODE') == 'enabled'): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('profile')); ?>">
                                        <?php echo e(__('Profile')); ?>

                                    </a>
                                <?php endif; ?>
                                <a class="dropdown-item" href="<?php echo e(route('changePassword')); ?>">
                                    <?php echo e(__('Change Password')); ?>

                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                                     document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Logout')); ?>

                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                    class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </nav>

        <main class="py-4 mb-5 mb-md-0">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <footer>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12 col-md-6 text-center text-md-left">
                        <p class=" mb-0">© <?php echo e(getSetting('APPLICATION_NAME')); ?> <?php echo e(date('Y')); ?></p>
                    </div>
                    <div class="col-12 col-md-6 text-center text-md-right">
                        <ul class="footer-links">
                            <li><a href="<?php echo e(route('privacyPolicy')); ?>"><?php echo e(__('Privacy Policy')); ?></a></li>
                            <li><a href="<?php echo e(route('termsAndConditions')); ?>"><?php echo e(__('Terms & Conditions')); ?></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
        <div class="cookie">
            <p><i class="fa fa-cookie-bite"></i>
                <?php echo e(__('This website uses cookies to ensure you get the best experience on our website')); ?>

                <a href="<?php echo e(route('privacyPolicy')); ?>"> <?php echo e(__('Learn more')); ?></a>
            </p>
            <button class="btn btn-theme confirm-cookie"><?php echo e(__('Got it')); ?></button>
        </div>
    </div>

    <script>
        const cookieConsent = "<?php echo e(getSetting('COOKIE_CONSENT')); ?>";
        const googleAnalyticsTrackingId = "<?php echo e(getSetting('GOOGLE_ANALYTICS_ID')); ?>";

        const languages = {
            error_occurred: "<?php echo e(__('An error occurred, please try again')); ?>",
            data_updated: "<?php echo e(__('Data updated successfully')); ?>",
            no_meeting: "<?php echo e(__('The meeting does not exist')); ?>",
            meeting_created: "<?php echo e(__('The meeting has been created')); ?>",
            confirmation: "<?php echo e(__('Are you sure')); ?>",
            meeting_deleted: "<?php echo e(__('The meeting has been deleted')); ?>",
            link_copied: "<?php echo e(__('Meeting link has been copied to the clipboard')); ?>",
            meeting_updated: "<?php echo e(__('The meeting has been updated')); ?>",
            sending_invite: "<?php echo e(__('Sending the invitation')); ?>",
            invite_sent: "<?php echo e(__('Invitation has been sent')); ?>",
            inviteMessage: "<?php echo e(__('Hey there! Join me for a meeting at this link')); ?>",
            no_session: "<?php echo e(__('Could not get the session details')); ?>",
            kicked: "<?php echo e(__('You have been kicked out of the meeting')); ?>",
            uploading: "<?php echo e(__('Uploading the file')); ?>",
            meeting_ended: "<?php echo e(__('Meeting ended')); ?>",
            cant_connect: "<?php echo e(__('Could not connect to the server, please try again later')); ?>",
            invalid_password: "<?php echo e(__('The password is invalid')); ?>",
            no_device: "<?php echo e(__('Could not get the devices, please check the permissions and try again. Error')); ?>",
            approve: "<?php echo e(__('Approve')); ?>",
            decline: "<?php echo e(__('Decline')); ?>",
            request_join_meeting: "<?php echo e(__('Request to join the meeting')); ?>",
            request_declined: "<?php echo e(__('Your request has been declined by the moderator')); ?>",
            double_click: "<?php echo e(__('Double click on the video to make it fullscreen')); ?>",
            single_click: "<?php echo e(__('Single click on the video to turn picture-in-picture mode on')); ?>",
            error_message: "<?php echo e(__('An error occurred')); ?>",
            kick_user: "<?php echo e(__('Kick this user')); ?>",
            participant_joined: "<?php echo e(__('A participant has joined the meeting')); ?>",
            confirmation_kick: "<?php echo e(__('Are you sure you want to kick this user')); ?>",
            participant_left: "<?php echo e(__('A participant has left the meeting')); ?>",
            camera_on: "<?php echo e(__('Camera has been turned on')); ?>",
            camera_off: "<?php echo e(__('Camera has been turned off')); ?>",
            mic_unmute: "<?php echo e(__('Mic has been unmute')); ?>",
            mic_mute: "<?php echo e(__('Mic has been muted')); ?>",
            no_fullscreen: "<?php echo e(__('Fullscreen mode is not supported in this browser')); ?>",
            no_video: "<?php echo e(__('The video is not playing or has no video track')); ?>",
            no_pip: "<?php echo e(__('Picture-in-picture mode is not supported in this browser')); ?>",
            link_copied: "<?php echo e(__('The meeting invitation link has been copied to the clipboard')); ?>",
            join_with_cam: "<?php echo e(__('Please join with a camera to use Screen Share feature')); ?>",
            cant_share_screen: "<?php echo e(__('Could not share the screen, please check the permissions and try again')); ?>",
            max_file_size: "<?php echo e(__('Maximum file size allowed (MB)')); ?>",
            view_file: "<?php echo e(__('View File')); ?>"
        }
    </script>

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.1.0\resources\views/layouts/app.blade.php ENDPATH**/ ?>