

<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('style'); ?>
    <style>
        h6 {
            width: 100%;
            text-align: center;
            border-bottom: 1px solid #000;
            line-height: 0.1em;
            margin: 10px 0 20px;
        }

        h6 span {
            background: #fff;
            padding: 0 10px;
        }

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('admin.plans.new')); ?>" method="post" id="form-coupon">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-name"><?php echo e(__('Name')); ?></label>
                            <input type="text" name="name" id="i-name"
                                class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('Name')); ?>">
                            <?php if($errors->has('name')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('name')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-currency"><?php echo e(__('Currency')); ?></label>
                            <select name="currency" id="i-currency"
                                class="custom-select<?php echo e($errors->has('currency') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('currency') == $key): ?> selected <?php endif; ?>>
                                        <?php echo e($key); ?> - <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('currency')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('currency')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-amount-month"><?php echo e(__('Monthly amount')); ?></label>
                            <input type="text" name="amount_month" id="i-amount-month"
                                class="form-control<?php echo e($errors->has('amount_month') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('amount_month')); ?>" placeholder="<?php echo e(__('Monthly amount')); ?>">
                            <?php if($errors->has('amount_month')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('amount_month')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-amount-year"><?php echo e(__('Yearly amount')); ?></label>
                            <input type="text" name="amount_year" id="i-amount-year"
                                class="form-control<?php echo e($errors->has('amount_year') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('amount_year')); ?>" placeholder="<?php echo e(__('Yearly amount')); ?>">
                            <?php if($errors->has('amount_year')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('amount_year')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-tax-rates"><?php echo e(__('Tax rates')); ?></label>
                            <select name="tax_rates[]" id="i-tax-rates"
                                class="custom-select<?php echo e($errors->has('tax_rates') ? ' is-invalid' : ''); ?>" size="3"
                                multiple>
                                <option value="">None</option>
                                <?php $__currentLoopData = $taxRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taxRate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($taxRate->id); ?>" <?php if(old('tax_rates') !== null && in_array($taxRate->id, old('tax_rates'))): ?> selected <?php endif; ?>>
                                        <?php echo e($taxRate->name); ?>

                                        (<?php echo e(number_format($taxRate->percentage, 2, __('.'), __(','))); ?>%
                                        <?php echo e($taxRate->type ? __('Exclusive') : __('Inclusive')); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('tax_rates')): ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($errors->first('tax_rates')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-coupons"><?php echo e(__('Coupons')); ?></label>
                            <select name="coupons[]" id="i-coupons"
                                class="custom-select<?php echo e($errors->has('coupons') ? ' is-invalid' : ''); ?>" size="3"
                                multiple>
                                <option value="">None</option>
                                <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($coupon->id); ?>" <?php if(old('coupons') !== null && in_array($coupon->id, old('coupons'))): ?> selected <?php endif; ?>>
                                        <?php echo e($coupon->name); ?>

                                        (<?php echo e(number_format($coupon->percentage, 2, __('.'), __(','))); ?>%
                                        <?php echo e($coupon->type ? __('Redeemable') : __('Discount')); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('coupons')): ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($errors->first('coupons')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-description"><?php echo e(__('Description')); ?></label>
                            <textarea id="i-description" name="description" rows="2" cols="50"
                                class="form-control<?php echo e($errors->has('description') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('description')); ?>" placeholder="<?php echo e(__('Description')); ?>"></textarea>
                            <?php if($errors->has('description')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('description')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <h6><span><?php echo e(__('Features')); ?></span></h6>

                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-features-video-chat"><?php echo e(__('Text chat')); ?></label>
                            <select name="features[text_chat]" id="i-features-global-domains"
                                class="custom-select<?php echo e($errors->has('features.text_chat') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('features.text_chat') == $key): ?> selected <?php endif; ?>>
                                        <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('features.text_chat')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('features.text_chat')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-features-video-chat"><?php echo e(__('File sharing')); ?></label>
                            <select name="features[file_share]" id="i-features-global-domains"
                                class="custom-select<?php echo e($errors->has('features.file_share') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('features.file_share') == $key): ?> selected <?php endif; ?>>
                                        <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('features.file_share')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('features.file_share')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-features-video-chat"><?php echo e(__('Screen sharing')); ?></label>
                            <select name="features[screen_share]" id="i-features-global-domains"
                                class="custom-select<?php echo e($errors->has('features.screen_share') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('features.screen_share') == $key): ?> selected <?php endif; ?>>
                                        <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('features.screen_share')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('features.screen_share')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-features-video-chat"><?php echo e(__('Whiteboard')); ?></label>
                            <select name="features[whiteboard]" id="i-features-global-domains"
                                class="custom-select<?php echo e($errors->has('features.whiteboard') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('features.whiteboard') == $key): ?> selected <?php endif; ?>>
                                        <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('features.whiteboard')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('features.whiteboard')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-features-video-chat"><?php echo e(__('Hand raise')); ?></label>
                            <select name="features[hand_raise]" id="i-features-global-domains"
                                class="custom-select<?php echo e($errors->has('features.hand_raise') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('features.hand_raise') == $key): ?> selected <?php endif; ?>>
                                        <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('features.hand_raise')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('features.hand_raise')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-features-video-chat"><?php echo e(__('Recording')); ?></label>
                            <select name="features[recording]" id="i-features-global-domains"
                                class="custom-select<?php echo e($errors->has('features.recording') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('features.recording') == $key): ?> selected <?php endif; ?>>
                                        <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('features.recording')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('features.recording')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-features-links"><?php echo e(__('Number of meetings')); ?></label>
                            <input type="number" name="features[meeting_no]"
                                class="form-control<?php echo e($errors->has('features.meeting_no') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('features.meeting_no') ?? 0); ?>">
                            <?php if($errors->has('features.meeting_no')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('features.meeting_no')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-features-links"><?php echo e(__('Time limit')); ?></label>
                            <input type="number" name="features[time_limit]"
                                class="form-control<?php echo e($errors->has('features.time_limit') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('features.time_limit') ?? 0); ?>">
                            <?php if($errors->has('features.time_limit')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('features.time_limit')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <button type="submit" id="save" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                <a href="<?php echo e(route('admin.plans')); ?>"><button type="button"
                        class="btn btn-default"><?php echo e(__('Back')); ?></button></a>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\jupitermeet_cc\JupiterMeet_2.5.0\jupitermeet\resources\views/admin/plans/new.blade.php ENDPATH**/ ?>