<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/fa.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/ionicons.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/responsive.bootstrap4.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/toastr.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/admin.css')); ?>" rel="stylesheet">
    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/images/FAVICON.png')); ?>">
    <?php echo $__env->yieldContent('style'); ?>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
                    <span class="navbar-toggler-icon"></span>
                </button>

                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav mr-auto">
                        <li class="nav-item">
                            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                        </li>
                    </ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="navbar-nav ml-auto">
                        <!-- Authentication Links -->
                        <?php if(auth()->guard()->guest()): ?>
                            <?php if(Route::has('login')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if(Route::has('register')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                                </li>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php if(Auth::user()->role == 'admin'): ?>
                                <li class="nav-item">
                                    <a class="nav-link active" href="<?php echo e(route('admin')); ?>"><?php echo e(__('Admin')); ?></a>
                                </li>
                            <?php endif; ?>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                            </li>

                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    <?php echo e(Auth::user()->username); ?>

                                </a>

                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="<?php echo e(route('changePassword')); ?>">
                                        Change Password
                                    </a>

                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        <?php echo e(__('Logout')); ?>

                                    </a>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="<?php echo e(route('admin')); ?>" class="brand-link">
              <img src="<?php echo e(asset('storage/images/SECONDARY_LOGO.png')); ?>" alt="<?php echo e(getSetting('APPLICATION_NAME')); ?>" class="brand-image img-circle elevation-3" style="opacity: .8">
              <span class="brand-text font-weight-light"><?php echo e(getSetting('APPLICATION_NAME')); ?></span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin')); ?>" class="nav-link" data-name="admin">
                              <i class="nav-icon fas fa-tachometer-alt"></i>
                              <p>
                                Dashboard
                              </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('meetings')); ?>" class="nav-link" data-name="meetings">
                              <i class="nav-icon fa fa-video"></i>
                              <p>
                                Meetings
                              </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('users')); ?>" class="nav-link" data-name="users">
                              <i class="nav-icon fa fa-users"></i>
                              <p>
                                Users
                              </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('income')); ?>" class="nav-link" data-name="income">
                              <i class="nav-icon fa fa-dollar-sign"></i>
                              <p>
                                Income
                              </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('global-config')); ?>" class="nav-link" data-name="global-config">
                              <i class="nav-icon fa fa-cog"></i>
                              <p>
                                Global Configuration
                              </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('signaling')); ?>" class="nav-link" data-name="signaling">
                              <i class="nav-icon fa fa-signal"></i>
                              <p>
                                Signaling Server
                              </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('content')); ?>" class="nav-link" data-name="content">
                              <i class="nav-icon fa fa-file-alt"></i>
                              <p>
                                Content
                              </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('update')); ?>" class="nav-link" data-name="update">
                              <i class="nav-icon fa fa-download"></i>
                              <p>
                                Manage Update
                              </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('license')); ?>" class="nav-link" data-name="license">
                              <i class="nav-icon fa fa-id-badge"></i>
                              <p>
                                Manage License
                              </p>
                            </a>
                        </li>
                   </ul>
               </nav>
            </div>
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <div class="content-header">
              <div class="container-fluid">
                <div class="row">
                  <div class="col-sm-6">
                    <h1 class="m-0"><?php echo $__env->yieldContent('page'); ?></h1>
                  </div><!-- /.col -->
                  <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                      <li class="breadcrumb-item"><a href="<?php echo e(route('admin')); ?>">Home</a></li>
                      <li class="breadcrumb-item active"><?php echo $__env->yieldContent('page'); ?></li>
                    </ol>
                  </div><!-- /.col -->
                </div><!-- /.row -->
              </div><!-- /.container-fluid -->
            </div>
            <!-- /.content-header -->

            <!-- Main content -->
            <section class="content">
              <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
              </div>
            </section>
        </div>
        <!-- /.content-wrapper -->

      <footer class="main-footer">
        <strong>Copyright &copy; <?php echo e(date('Y')); ?> <?php echo e(getSetting('APPLICATION_NAME')); ?>.</strong>
        All rights reserved.
        <div class="float-right d-none d-sm-inline-block">
          <b>Version</b> <?php echo e(getSetting('VERSION')); ?>

        </div>
      </footer>
    </div>

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/common.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.0.0\resources\views/layouts/admin.blade.php ENDPATH**/ ?>