<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
  <div class="container">
      <h3 class="mb-3">Hi, <?php echo e(auth()->user()->username); ?>!</h3>

      <?php if(Session::has('success')): ?>
          <div class="alert alert-success text-center" role="alert">
              <?php echo e(Session::get('success')); ?>

          </div>
      <?php endif; ?>

      <?php if(auth()->user()->plan_status == 'active'): ?>
          <p>Your plan is <span class="badge badge-success">Active</span> and is valid till <?php echo e(!$userPlan->isEmpty() ? $userPlan[0]->plan_end_date : '-'); ?>.</p>
      <?php elseif(auth()->user()->plan_status == 'inactive'): ?>
          <p>Your plan is <span class="badge badge-info">Inactive</span>, <a href="<?php echo e(route('pricing')); ?>">Upgrade now</a>!</p>
      <?php else: ?>
          <p>Your plan is <span class="badge badge-danger">Expired</span>, <a href="<?php echo e(route('pricing')); ?>">Upgrade now</a>!</p>
      <?php endif; ?>

      <?php if(!$userPlan->isEmpty()): ?>
      <div class="table-responsive mb-3">
          <table class="table table-striped">
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Amount</th>
                <th scope="col">Type</th>
                <th scope="col">Currency</th>
                <th scope="col">Gateway</th>
                <th scope="col">Plan Start Date</th>
                <th scope="col">Plan End Date</th>
              </tr>
            </thead>
            <tbody>
               <?php $__currentLoopData = $userPlan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <th scope="row"><?php echo e($key + 1); ?></th>
                <td><?php echo e($value->amount); ?></td>
                <td><?php echo e(ucfirst($value->type)); ?></td>
                <td><?php echo e($value->currency); ?></td>
                <td><?php echo e(ucfirst($value->gateway)); ?></td>
                <td><?php echo e($value->plan_start_date); ?></td>
                <td><?php echo e($value->plan_end_date); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
      </div>
      <?php else: ?>
          <p>Your transactions will be displayed here.</p>
      <?php endif; ?>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\resources\views/profile.blade.php ENDPATH**/ ?>